#include <sourcemod>
#include <sdktools>
#include <colors>

#define PLUGIN_AUTHOR	"tuty"
#define PLUGIN_VERSION	"1.1.1"
#pragma semicolon 1

new Handle:gPluginEnabled = INVALID_HANDLE;
new Handle:gAnnounceMessage = INVALID_HANDLE;

public Plugin:myinfo =
{
	name = "Resetscore",
	author = PLUGIN_AUTHOR,
	description = "Type !resetscore in chat to reset your score.",
	version = PLUGIN_VERSION,
	url = "www.ligs.us"
};

public OnPluginStart()
{
	RegConsoleCmd( "say", CommandSay );
	RegConsoleCmd( "say_team", CommandSay );
	
	gPluginEnabled = CreateConVar( "sm_resetscore", "1" );
	gAnnounceMessage = CreateConVar( "sm_resetscore_Announce", "1" );
	CreateConVar( "resetscore_version", PLUGIN_VERSION, "Reset Score", FCVAR_PLUGIN | FCVAR_SPONLY | FCVAR_REPLICATED | FCVAR_NOTIFY );
	
	LoadTranslations("resetscore.phrases");
	
	if (GetConVarInt( gPluginEnabled ) && GetConVarInt( gAnnounceMessage ))
	{
		HookEvent("round_start", OnRoundStart);
	}
}

public OnConfigsExecuted()
{
	GetConVarInt( gPluginEnabled );
	GetConVarInt( gAnnounceMessage );	
}

public Action:CommandSay( id, args )
{
	decl String:Said[ 128 ];
	GetCmdArgString( Said, sizeof( Said ) - 1 );
	StripQuotes( Said );
	TrimString( Said );
	
	if( StrEqual( Said, "!resetscore" , false ) || StrEqual( Said, "!restartscore" , false ) || StrEqual( Said, "!rs" , false ) )
	{
		if( GetConVarInt( gPluginEnabled ) == 0 )
		{
			CPrintToChat( id, "%t", "plugin disabled" );
			PrintToConsole( id, "%t", "Console plugin disabled" );
		
			return Plugin_Continue;
		}

		if( GetClientDeaths( id ) == 0 && GetClientFrags( id ) == 0 )
		{
			CPrintToChat( id, "%t",  "Your score is 0");
			PrintToConsole( id, "%t", "Console Your score no" );
			
			return Plugin_Continue;
		}
				
		SetClientFrags( id, 0 );
		SetClientDeaths( id, 0 );
	
		decl String:Name[ 32 ];
		GetClientName( id, Name, sizeof( Name ) - 1 );
	
		CPrintToChat( id, "%t", "reseted your score" );
		CPrintToChatAllEx( id, "%t", "reseted score", Name );
		PrintToConsole( id, "%t", "reseted your score" );
	}
	
	return Plugin_Continue;
}

public Action:OnRoundStart(Handle:event, const String:name[], bool:dontBroadcast)
{
	if ( GetConVarInt( gAnnounceMessage ))
	{
		CPrintToChatAll("%t", "Announce Message");
	}
}
 
stock SetClientFrags( index, frags )
{
	SetEntProp( index, Prop_Data, "m_iFrags", frags );
	return 1;
}

stock SetClientDeaths( index, deaths )
{
	SetEntProp( index, Prop_Data, "m_iDeaths", deaths );
	return 1;
}
