﻿import es
import datetime
import effectlib
import gamethread
import playerlib
import matrixv
import pickle
import os
import popuplib2
from vecmath import Vector as V
from random import randint as Ra
import font
reload(font)
font =  font.font







info = es.AddonInfo()
info.name     = "NEW 2012 YEAR"
info.version  = '1.00'
info.url      = "http://addons.eventscripts.com/addons/user/46969"
info.basename = "ny2012"
info.author   = "sega74rus"
es.ServerVar('teamkill_admin', info.version, info.name).makepublic()















ny = datetime.datetime(2012,1,1,0,0,0,0)


admpath =es.getAddonPath(__name__.split('.')[0])  +'/admins.txt'
t = open(admpath).read().strip('\xef\xbb\xbf').split('\n')
admins = [s.split('//')[0].strip() for s in t if s.split() and  not s.strip().startswith('//')]



def inadmins(userid):
    pl = playerlib.getPlayer(userid)
    steam = pl.steamid
    ip =  pl.address.split(':')[0]

    if steam in admins or ip in admins:
        return 1
        

def getTimeLleft():
    curent = datetime.datetime.today()
    d =  ny - curent 

    if curent > ny:
        return ':2012:'
    if d.days:
        return u'ДНЕЙ ' + str(d).split('.')[0]
    return str(d).split('.')[0]
    
    
def lastHour():
    curent = datetime.datetime.today()
    if curent > ny:
        return 
        
    d =  ny - curent 

    if not d.days and d.seconds <  216000:
        return True
     


class Board(object):
    def __init__(self,pos,w=50,h=100,dw = 60,pitch=0,yaw=0,roll=0):
        ''' w= wight
            h= height
            dw  wight for next ch'''
        self.pos = V(pos)
        self.w = w
        self.h = h
        self.dw = dw
        self.color = 10,10,255
        self.linesize = 10
        self.pitch=pitch
        self.yaw=yaw
        self.roll=roll
        
    def draw(self,text,linesec = 0.21,delta = 0):

        d = 0
        for s in text:
            seg = font.get(s,None)
            d+=1 
        
            if seg:
             
                for line in seg:
                    a,b = line
                    a = list(a)
                    b = list(b)
                    a[0] *= self.w
                    a[0] += d*self.dw-delta*self.dw
                    a[1] *= self.h       
                    b[0] *= self.w
                    b[0] += d*self.dw-delta*self.dw
                    b[1] *= self.h
     
                    c0 = V(matrixv.povorotMatrix0(a,self.pitch,self.yaw,self.roll)) + self.pos
                    c1 = V(matrixv.povorotMatrix0(b,self.pitch,self.yaw,self.roll))+ self.pos
                    effectlib.drawLine(c1,c0,seconds =linesec,
                                red=self.color[0],  
                                green=self.color[1],
                                blue=self.color[2],
                                width=self.linesize) 
    

class BoardManager(object):
    def __init__(self):
    
        self.mapsdir = es.getAddonPath(__name__.split('.')[0]) +'/maps/'
        self.list = []
        self.maxline = 15
        self._indexadvert = -1
        self._showtime = 1
        self._timecount = 0
        self.delta = 0
        self.selected = None
        self.load()
        
    def load(self):
        path =es.getAddonPath(__name__.split('.')[0])  
        
        self.advert = []
        for line in open(path+'/advert.txt').readlines():
            line =line.lstrip('\xef\xbb\xbf').strip()
            if line:
                self.advert.append(' '*self.maxline + line.decode('utf8').upper())
        #print self.advert
        
        self.list = []
        fname = self.mapsdir + es.ServerVar("eventscripts_currentmap")+'.ny'
        if os.path.isfile(fname):
            pkl_file = open(fname, 'rb')
            self.list = pickle.load(pkl_file)
            pkl_file.close()
           

    def save(self):
        fname = self.mapsdir + es.ServerVar("eventscripts_currentmap")+'.ny'
        output = open(fname, 'wb')
        pickle.dump(self.list, output)
        output.close()
        
        
        
        
    def addBoard(self,*args, **kw):
        self.list.append(Board(*args,**kw))
        return len(self.list)-1
    def delBoard(self,index):
        del self.list[index]
    def draw(self):
        if type(self.selected) == int:
             self._showtime = 1
        if self._showtime:
            self._timecount += 1
            
            if self._timecount > 50:
                self._timecount = 0
                if lastHour():
                  
                    es.msg('soon new Yaer!!!')
                else:
                    self._showtime = 0
                
                self._indexadvert = self._indexadvert + 1 if self._indexadvert<len(self.advert)-1 else 0
            tt =   getTimeLleft() 
            deltasm = 0
            linesec = .4
            
            
        else:
            text1 = self.advert[self._indexadvert]
            
        
            if self.delta> 5*len(text1) :
                self.delta = 0
                self._showtime = 1
            else:
                self.delta+= 1
            deltasm = self.delta%5 /5.0    
        
            tt= text1[self.delta/5:self.delta/5+self.maxline]
          
            linesec = .21
     
     
        for i,b in enumerate(self.list):
            gamethread.delayed(0.016*i,b.draw,tt,{'delta': deltasm,'linesec' :linesec })
    def getBoard(self,index):
        return self.list[index]
            
            
            
manager = BoardManager()

#WorldMins = V(es.getindexprop(0, "CWorld.m_WorldMins"))
#WorldMaxs = V(es.getindexprop(0, "CWorld.m_WorldMaxs"))
#centr = (WorldMins + WorldMaxs) / 2


#manager.addBoard(centr)



def redraw():
    manager.draw()
    gamethread.delayedname(0.2, 'NYBOARdS', redraw)  
        
        
redraw()  
        
def unload():
    gamethread.cancelDelayed( 'NYBOARdS')
    
    
    
def menuHead_builder(userid, popup):
    popup.add('create', 'add board')
    popup.add('select', 'edit')
    popup.add('save&exit', 'save and exit')
    popup.add('exit', 'exit, no save')
    
    
def menuHead_menuselect(params):
    userid = int(params['userid'])
    choice = params['choice']
    if choice == 'create':
        coo = playerlib.getPlayer(userid).getViewCoord() 
        centr = V(coo)
        manager.addBoard(centr)
        manager.selected= -1
    if choice == 'select':
        return selectmenu

    if choice == 'save&exit':    
        manager.save()
        es.msg('\3Saved')
        manager.selected= None
        return  
    if choice == 'exit':
        es.msg('\3no Saved')
        manager.selected= None
        return
        
    return menuHead
    

    

menuHead = popuplib2.PersonalMenu(menuHead_builder)
menuHead.menuselect  = menuHead_menuselect   
menuHead.title  = 'NEW 2012'



def selectmenu_builder(userid, popup):
    l = len(manager.list)
    for x in range(l):
        popup.add(x, x)

        
        
def selectmenu_menuselect(params):
    userid = int(params['userid'])
    choice = params['choice']
    manager.selected = choice
    return menuEdit
        
    return selectmenu

selectmenu = popuplib2.PersonalMenu(selectmenu_builder)
selectmenu.menuselect  = selectmenu_menuselect   
selectmenu.title  = 'select board:'


def menuEdit_builder(userid, popup):
    popup.title  = 'edit %s' %manager.selected
    
    popup.add('moveit', 'moveit')
    popup.add('move', 'move xyz')
    popup.add('rotate', 'rotate')
    popup.add('size', 'edit size')
    popup.add('delete', 'delete')
    

def menuEdit_menuselect(params):
    userid = int(params['userid'])
    choice = params['choice']
    if choice == 'delete':
        manager.delBoard(manager.selected)
        manager.selected = -1
        return selectmenu
    if choice == 'moveit':
        coo = playerlib.getPlayer(userid).getViewCoord() 
        centr = V(coo)
        b = manager.getBoard(manager.selected)
        b.pos = centr
        return menuEdit
        
    if choice == 'move':
        return menuEditMove         
    if choice == 'rotate':
        return menuEditrotate        
    if choice == 'size':
        return menuEditsize  
    
      

    return menuEdit


menuEdit = popuplib2.PersonalMenu(menuEdit_builder)
menuEdit.menuselect  = menuEdit_menuselect



def menuEditrotate_builder(userid, popup):
    b  = manager.getBoard(manager.selected)
    popup.title  = 'angle %s %s %s' %(b.pitch,b.yaw,b.roll)

    popup.add('r+p', '+pitch')
    popup.add('r-p', '-pitch ')    
    popup.add('r+y', '+yaw')
    popup.add('r-y', '-yaw ')    
    popup.add('r+r', '+roll')
    popup.add('r-r', '-roll ')
    
def menuEditsize_builder(userid, popup):
    b  = manager.getBoard(manager.selected)
    popup.title  = 'size %sx%s %s' %(b.w,b.h, b.linesize)

    popup.add('s+w', '+w')
    popup.add('s-w', '-w ')  
    popup.add('s+h', '+h')
    popup.add('s-h', '-h ')   

    popup.add('s+l', '+ linesize')
    popup.add('s-l', '- linesize ')   

    


def menuEditMove_builder(userid, popup):
    popup.title  = 'edit %s' %manager.selected
    
    for x in 'xyz':
        popup.add('m+'+x, x+'+')
        popup.add('m-'+x, x+'- ')
        
        
        

def menuEditMove_menuselect(params):
    userid = int(params['userid'])
    choice = params['choice']
    b  = manager.getBoard(manager.selected)
    zn = 1 if choice[1]=='+' else -1
   
    if choice[0] == 'm':
        b.pos['xyz'.find(choice[2])] += 10*zn 
        return menuEditMove
    elif choice[0] == 'r':

        if choice[2] == 'p':
            b.pitch += 90*zn  
           # b.pitch 
        elif choice[2] == 'y':
            b.yaw += 90*zn    
        elif choice[2] == 'r':
            b.roll += 90*zn
        return  menuEditrotate  
            
    elif choice[0] == 's':

        if choice[2] == 'w':
            b.w += 10*zn  
            b.dw  = b.w+ b.w*0.2  
        elif choice[2] == 'h':
            b.h += 10*zn  
            
        elif choice[2] == 'l':
            b.linesize += 1*zn  
            if b.linesize <1:
                b.linesize = 1

            
        return menuEditsize
        
 
 
        
        
        
menuEditMove = popuplib2.PersonalMenu(menuEditMove_builder)
menuEditMove.menuselect  = menuEditMove_menuselect         
        
menuEditrotate = popuplib2.PersonalMenu(menuEditrotate_builder)
menuEditrotate.menuselect  = menuEditMove_menuselect   

menuEditsize = popuplib2.PersonalMenu(menuEditsize_builder)
menuEditsize.menuselect  = menuEditMove_menuselect   




def player_say(ev):

    userid = int(ev['userid'])
    t = ev['text'].lower()
    if t == '!ny':
        if inadmins(userid):
            menuHead.send(userid)
        else:    
            es.tell(userid,'\3insufficient privileges')

    
def es_map_start(event_var): 
    manager.load()
    
    
    
    

