﻿from math import sin, cos , pi
''' This module calculates the position of a point in space after turning around three axes. identical with Valve, Source
    http://en.wikipedia.org/wiki/Rotation_matrix
    author sega74rus
    version 1.0'''

def povorotMatrix(p0,p,pitch=0,yaw=0,roll=0):
    ''' 
    returns a new point, turn on the first point on the specified angles   
    arguments:
    p0 - list(x,y,z) substitute center 
    p  - list(x,y,z) previous point (pitch,yaw,roll =0)
    pitch,yaw,roll - new angles
    returns point p with the new angles
    '''
    
    b,a,c = pitch,yaw,roll
    x = p[0] - p0[0]
    y = p[1] - p0[1]
    z = p[2] - p0[2]

    ar = pi/180 * a 
    br = pi/180 * b
    cr = pi/180 * c
    cosa= cos(ar) 
    sina= sin(ar)
    cosb= cos(br)
    sinb= sin(br)
    cosc= cos(cr)
    sinc= sin(cr)
    m11 = cosa*cosb
    m21 = cosa*sinb*sinc-sina*cosc
    m31 = cosa*sinb*cosc +sina*sinc
    m12 = sina*cosb
    m22 =  sina*sinb*sinc+cosa*cosc
    m32 = sina*sinb*cosc -cosa*sinc
    m13 = -sinb
    m23 = cosb*sinc
    m33 = cosb*cosc

    x1 = x*m11 + y*m21 + z*m31
    y1 = x*m12 + y*m22 + z*m32
    z1 = x*m13 + y*m23 + z*m33
    x = p0[0] + x1
    y = p0[1] + y1
    z = p0[2] + z1
    return (x,y,z) 
    
    
    
def povorotMatrix0(p,pitch=0,yaw=0,roll=0):
    ''' 
    returns a new point, turn on the first point on the specified angles   
    arguments:
    p  - list(x,y,z) or tuple previous point (pitch,yaw,roll =0)
    pitch,yaw,roll - new angles
    returns point p with the new angles
    '''
    
    b,a,c = pitch,yaw,roll
    x = p[0] 
    y = p[1]
    z = p[2] 

    ar = pi/180 * a 
    br = pi/180 * b
    cr = pi/180 * c
    cosa= cos(ar) 
    sina= sin(ar)
    cosb= cos(br)
    sinb= sin(br)
    cosc= cos(cr)
    sinc= sin(cr)
    m11 = cosa*cosb
    m21 = cosa*sinb*sinc-sina*cosc
    m31 = cosa*sinb*cosc +sina*sinc
    m12 = sina*cosb
    m22 =  sina*sinb*sinc+cosa*cosc
    m32 = sina*sinb*cosc -cosa*sinc
    m13 = -sinb
    m23 = cosb*sinc
    m33 = cosb*cosc

    x1 = x*m11 + y*m21 + z*m31
    y1 = x*m12 + y*m22 + z*m32
    z1 = x*m13 + y*m23 + z*m33

    return (x1,y1,z1)
    
    